# 画面設計書 26-Runtime Config Test（RuntimeConfig）

## 概要

本ドキュメントは、WebAssembly ランタイム設定テスト画面（index.html）の画面設計書です。.NET WebAssembly 環境における runtimeconfig.json の設定値が正しく読み込まれ、AppContext.GetData() で取得できることをテストするための HTML/JavaScript ページとして実装されています。

### 本画面の処理概要

この画面は、.NET WebAssembly 環境でランタイム設定（runtimeconfig.json）の configProperties が正しく適用され、アプリケーションコードから参照できることを検証するためのテストページです。また、Jiterpreter のランタイムオプションが正しく伝播されることも確認します。

**業務上の目的・背景**：本画面は .NET Runtime の機能テストとして、WebAssembly 環境における runtimeconfig.json の設定機能を検証するために存在します。runtimeconfig.json は .NET アプリケーションのランタイム動作を制御する重要な設定ファイルであり、この設定が WebAssembly 環境でも正しく機能することを確認します。また、`withRuntimeOptions()` API による Jiterpreter オプションの指定も検証します。

**画面へのアクセス方法**：WebAssembly アプリケーションをビルド・起動後、ブラウザで index.html にアクセスすることで本画面が表示されます。

**主要な操作・処理内容**：
1. ページ読み込み時に .NET WebAssembly ランタイムを初期化
2. `withRuntimeOptions(["--jiterpreter-stats-enabled"])` でランタイムオプションを設定
3. JavaScript から .NET の `TestMeaning()` メソッドを呼び出し
4. `AppContext.GetData("test_runtimeconfig_json")` で設定値を取得
5. 設定値が "25" であることを検証
6. Jiterpreter の enableStats オプションが有効であることを検証
7. テスト結果（42: 成功、1: 失敗）を画面とコンソールに出力

**画面遷移**：本画面は単独で動作するテストページであり、他の画面への遷移機能はありません。

**権限による表示制御**：本画面は認証・認可による表示制御を実装していません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyランタイム設定のテスト実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 32 | Microsoft.Extensions.Configuration | 補助機能 | ランタイム設定の読み込みテスト |

## 画面種別

機能テストページ / ランタイム設定テスト

## URL/ルーティング

- **URL**: `/index.html`（静的 HTML ファイル）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ret | 出力 | int | - | テスト結果コード（42: 成功、1: 失敗） |

## 表示項目

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|--------------|------|
| ページタイトル | title | 固定値 | "Runtime config test" |
| ヘッダー | h3 | 固定値 | "Runtime config test" |
| 結果表示プレフィックス | テキスト | 固定値 | "Answer to the Ultimate Question of Life, the Universe, and Everything is :" |
| テスト結果 | span#out | ret 変数 | テスト結果の数値（正常時: 42） |
| テスト完了フラグ | label#tests_done | exit_code | テスト完了時に動的に追加される要素 |

## イベント仕様

### 1-ページ読み込み時処理

**トリガー**: ページの読み込み完了時（main.js の実行）

**処理フロー**:
1. `dotnet.js` モジュールをインポート
2. `withRuntimeOptions(["--jiterpreter-stats-enabled"])` でランタイムオプションを設定
3. `.create()` で .NET ランタイムを初期化
4. `getAssemblyExports()` でアセンブリのエクスポートを取得
5. `TestMeaning()` メソッドを呼び出し
6. 結果を `#out` 要素に表示
7. `INTERNAL.jiterpreter_get_options().enableStats` で Jiterpreter オプションを検証
8. `wasm_exit()` を呼び出してテスト完了を通知

### 2-TestMeaning メソッド実行

**トリガー**: JavaScript からの呼び出し

**処理フロー**:
1. `AppContext.GetData("test_runtimeconfig_json")` を呼び出して設定値を取得
2. 取得した値が "25" であるかを検証
3. 成功なら 42 を返却、失敗なら 1 を返却

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースとの連携を行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG-001 | ログ出力 | "ret: {ret}" | TestMeaning 実行後 |
| MSG-002 | ログ出力 | "WASM EXIT {exit_code}" | テスト完了時 |
| MSG-003 | ログ出力 | "WASM ERROR {err}" | エラー発生時 |
| MSG-004 | エラー | "RuntimeOptions not propagated" | Jiterpreter オプションが未設定時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| JavaScript Error | .NET ランタイム初期化失敗 | コンソールに "WASM ERROR" を出力 |
| JavaScript Error | RuntimeOptions 未伝播 | "RuntimeOptions not propagated" をスロー |
| 検証失敗 | AppContext.GetData() の値が "25" でない | 終了コード 1 を返却 |

## 備考

- 本画面は `.NET Runtime` リポジトリの機能テストであり、WebAssembly 環境でのランタイム設定機能を検証する目的で作成されています。
- `runtimeconfig.template.json` で `test_runtimeconfig_json: "25"` を設定しています。
- `--jiterpreter-stats-enabled` オプションにより、Jiterpreter の統計情報収集が有効化されます。
- テスト結果 42 は「生命、宇宙、そして万物についての究極の疑問の答え」（銀河ヒッチハイク・ガイド）の引用です。
- `tests_done` ラベルはテストランナーがテスト完了を検出するために使用されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ランタイム設定ファイルの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runtimeconfig.template.json | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/runtimeconfig.template.json` | configProperties の設定内容（1-6行目） |

**読解のコツ**: `configProperties` 内の設定値は `AppContext.GetData()` で取得できます。`test_runtimeconfig_json: "25"` がテスト対象の設定です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/index.html` | HTML 構造と main.js の読み込み（1-18行目） |
| 2-2 | main.js | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/main.js` | .NET ランタイム初期化とランタイムオプション設定（1-29行目） |

**主要処理フロー**:
1. **index.html 11行目**: `<script type='module' src="./main.js">` で main.js を読み込み
2. **main.js 13行目**: `dotnet.withRuntimeOptions(["--jiterpreter-stats-enabled"]).create()` でランタイム初期化
3. **main.js 14-17行目**: TestMeaning メソッドの呼び出しと結果表示
4. **main.js 20-22行目**: Jiterpreter オプションの検証

#### Step 3: テストロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/Program.cs` | TestMeaning メソッドの実装（1-24行目） |

**主要処理フロー**:
- **17-18行目**: `[JSExport]` 属性で JavaScript から呼び出し可能に
- **20行目**: `AppContext.GetData("test_runtimeconfig_json")` で設定値取得
- **21行目**: 値が "25" であるか検証し、結果を返却

### プログラム呼び出し階層図

```
index.html
    │
    └─ main.js (type="module")
           │
           ├─ import { dotnet } from './_framework/dotnet.js'
           │
           ├─ dotnet.withRuntimeOptions(["--jiterpreter-stats-enabled"])
           │
           ├─ dotnet.create()
           │      └─ [.NET ランタイム初期化]
           │             └─ [runtimeconfig.json 読み込み]
           │
           ├─ getAssemblyExports("WebAssembly.Browser.RuntimeConfig.Test.dll")
           │
           ├─ exports.Sample.Test.TestMeaning()
           │      │
           │      └─ AppContext.GetData("test_runtimeconfig_json")
           │             │
           │             └─ 値が "25" か検証
           │                    │
           │                    └─ return 42 (success) or 1 (failure)
           │
           └─ INTERNAL.jiterpreter_get_options().enableStats
                  │
                  └─ true でなければ Error をスロー
```

### データフロー図

```
[入力]                    [処理]                        [出力]

runtimeconfig.json
    │
    └─ configProperties ────▶ .NET ランタイム初期化
           │                        │
           │                        ▼
           │                  AppContext に設定値を格納
           │                        │
           │                        ▼
           └──────────────▶ AppContext.GetData("test_runtimeconfig_json")
                                    │
                                    ▼
                             値が "25" か検証 ───────▶ 結果表示
                                                        span#out: 42
                                                        │
                                                        ▼
RuntimeOptions ──────────▶ jiterpreter_get_options()
    │                             │
    │                             ▼
    └──────────────────── enableStats: true か検証
                                  │
                                  ▼
                           label#tests_done: 42
                                  │
                                  ▼
                           console: "WASM EXIT 42"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/index.html` | テンプレート | テストページの HTML |
| main.js | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/main.js` | ソース | JavaScript エントリーポイント |
| Program.cs | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/Program.cs` | ソース | テストロジック（TestMeaning） |
| runtimeconfig.template.json | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/runtimeconfig.template.json` | 設定 | ランタイム設定テンプレート |
| WebAssembly.Browser.RuntimeConfig.Test.csproj | `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/WebAssembly.Browser.RuntimeConfig.Test.csproj` | 設定 | プロジェクト設定 |
